/*===================================*/
/*                                   */
/* Musis Quest Programmer's ToolKit  */
/*                                   */
/*===================================*/
/*                                   */
/* Definitions for commands          */
/*                                   */
/*===================================*/
/*                                   */
/* Copyright (c) 1988, 1990          */
/* Music Quest, Inc.                 */
/*                                   */
/*===================================*/

#define M_STOP                  0x01 /* Send MIDI stop to MIDI-out. */
#define M_START                 0x02 /* Send MIDI start to MIDI-out. */
#define M_CONTINUE              0x03 /* Send MIDI continue to MIDI-out. */
#define STOP_PLAY               0x05 /* Stop play back and send MIDI stop. */
#define START_PLAY              0x0A /* Start play back and send MIDI start. */
#define CONTINUE_PLAY           0x0B /* Continue play back and send MIDI continue. */
#define MTCM_SYNCH              0x0C /* MTC->MIDI clock sync. */
#define MTCA_SYNCH              0x0D /* MTC absolute clock sync. */
#define STOP_REC                0x11 /* Stop recording and send MIDI stop. */
#define STOP_RECPLAY            0x15 /* Stop recording and play back, and MIDI stop. */
#define STOP_RECSMPTE           0x1C /* Stop recording SMPTE tape sync data */
#define STOP_SMPTE_READ         0x1D /* Stop reading SMPTE tape sync */
#define REC_STANDBY             0x20 /* Recording standby. */
#define START_REC               0x22 /* Start recording and send MIDI start. */
#define CONTINUE_REC            0x23 /* Continue recording and send MIDI continue. */
#define START_PLAY_RECSTDBY     0x28 /* Start play back and enter recording standby. */
#define START_PLAY_REC          0x2A /* Start play back and recording, and send MIDI start. */
#define CONTINUE_PLAY_REC       0x2B /* Continue play back and recording, and send MIDI continue. */
#define START_RECSMPTE          0x2C /* Start recording SMPTE tape sync data */
#define START_SMPTE_READ        0x2D /* Start reading SMPTE tape sync */
#define DISABLE_MTC             0x31 /* Disable MIDI time code messages */
#define DISABLE_RT              0x32 /* Disable MIDI real time messages (clock, start, stop, continue). */
#define DISABLE_ALL_THRU        0x33 /* Disable MIDI thru. */
#define ENABLE_TB               0x34 /* Send data in stop state messages with timing byte. */
#define ENABLE_MODEMSG          0x35 /* Enable mode messages to PC. */
#define ENABLE_SYSEX_THRU       0x37 /* Enable system exclusive through messages. */
#define ENABLE_SYSCOM_PC        0x38 /* Enable system common messages to PC. */
#define ENABLE_RT_PC            0x39 /* Enable real time messages to PC. */
#define DISABLE_SMPTE_MSG       0x3A /* Disable SMPTE frame messages to PC. */
#define ENABLE_SMPTE_MSG        0x3B /* Enable SMPTE frame messages to PC. */
#define CLS_MODE                0x3C /* Chase Lock Sync mode */
#define SMPTE_MODE              0x3D /* SMPTE Sync mode */
#define UART_MODE               0x3F /* Enter pass-thru or UART mode. */
#define INT_SYNCH               0x80 /* Use internal synchronization. */
#define MIDI_SYNCH              0x82 /* Use MIDI synchronization. */
#define METRO_ON                0x83 /* Metronome on, without accents. */
#define METRO_OFF               0x84 /* Metronome off. */
#define METRO_ACCENTS           0x85 /* Metronome on, with accents. */
#define DISABLE_BENDER_PC       0x86 /* Filter out bender/controller MIDI messages. */
#define ENABLE_BENDER_PC        0x87 /* Enable bender/controller MIDI messages to PC. */
#define DISABLE_THRU            0x88 /* Disables MIDI-thru for acceptable channel messages. */
#define ENABLE_THRU             0x89 /* Enables MIDI-thru for acceptable channel messages. */
#define DISABLE_STOP_MSGS       0x8A /* Disable MIDI messages to PC when stopped. */
#define ENABLE_STOP_MSGS        0x8B /* Enable MIDI messages to PC when stopped. */
#define DISABLE_MEASUREND       0x8C /* Disable measure end messages to PC. */
#define ENABLE_MEASUREND        0x8D /* Enable measure end messages to PC. */
#define DISABLE_CONDUCTOR       0x8E /* Disable conductor track. */
#define ENABLE_CONDUCTOR        0x8F /* Enable conductor track. */
#define DISABLE_MIDI_CTRL       0x90 /* Disable external MIDI control. */
#define ENABLE_MIDI_CTRL        0x91 /* Enable external MIDI control. */
#define DISABLE_CLOCK_PC        0x94 /* Disable clock-to-PC messages. */
#define ENABLE_CLOCK_PC         0x95 /* Enable clock-to-PC messages. */
#define DISABLE_SYSEX_PC        0x96 /* Disable system exclusive messages to PC. */
#define ENABLE_SYSEX_PC         0x97 /* Enable system exclusive messages to PC. */
#define REQ_PLAY_CNTR           0xA0 /* Request play counter for track 1. */
                                     /* A1 - A7 for tracks 2 - 8 */
#define REQ_USERBITS            0xAA /* Request SMPTE user bits */
#define REQ_REC_CNTR            0xAB /* Read and clear record counter. */
#define REQ_VERSION             0xAC /* Request MCC version number. */
#define REQ_REVISION            0xAD /* Request MCC revision number (obsolete). */
#define REQ_FEATURES            0xAD /* Request installed features. */
#define REQ_TEMPO               0xAF /* Request current, active tempo. */
#define RESET_REL_TEMPO         0xB1 /* Reset relative tempo setting. */
#define CLEAR_PLAY_TRACKS       0xB8 /* Clear all play track counters. */
#define CLEAR_PLAY_MAP          0xB9 /* Clear play map. */
#define CLEAR_REC_CNTR          0xBA /* Clear record counter. */
#define INT_CLOCK_48            0xC2 /* Set internal clock to 48 ticks/beat. */
#define INT_CLOCK_72            0xC3 /* Set internal clock to 72 ticks/beat. */
#define INT_CLOCK_96            0xC4 /* Set internal clock to 96 ticks/beat. */
#define INT_CLOCK_120           0xC5 /* Set internal clock to 120 ticks/beat. */
#define INT_CLOCK_144           0xC6 /* Set internal clock to 144 ticks/beat. */
#define INT_CLOCK_168           0xC7 /* Set internal clock to 168 ticks/beat. */
#define INT_CLOCK_192           0xC8 /* Set internal clock to 192 ticks/beat. */
#define REQ_SEND_PT             0xD0 /* Request to send message on play track 1. */
                                     /* D1-D7 for tracks 2-8 */
#define REQ_SEND_SYS            0xDF /* Request to send system message. */
#define SET_TEMPO               0xE0 /* Set tempo. */
#define SET_REL_TEMPO           0xE1 /* Set relative tempo. */
#define SET_GRADUATION          0xE2 /* Set relative tempo change graduation. */
#define SET_METRO               0xE4 /* Set number of MIDI clocks per metronome click. */
#define SET_BPM                 0xE6 /* Set number of beats per measure, for the metronome. */
#define SET_CLOCK_PC            0xE7 /* Set clock-to-PC message rate, in terms of internal clock ticks. */
#define SET_CLS_DELAY           0xEA /* Set CLS delay time (in seconds). */
#define SET_MIDI_PATH           0xEB /* Set MIDI path for message group. */
#define ACTIVE_TRACKS           0xEC /* Set active play back tracks. */
#define OVRERDUB_REC_CNTRS      0xED /* Select tracks whose play counters will be sent when recording starts. */
#define CHANNELS_1              0xEE /* Select acceptable channels 1-8. */
#define CHANNELS_9              0xEF /* Select acceptable channes 9-16. */
#define SMPTE_CONTROL           0xF4 /* SMPTE control data. */
#define SET_PROG_METRO          0xF5 /* Set programmable metronome. */
#define SMPTE_ORIGIN            0x00 /* SMPTE control data, set origin subfunction */
#define SMPTE_USER              0x01 /* SMPTE control data, set user bits subfunction */
#define SMPTE_CUE_POINT         0x02 /* SMPTE control data, set cue point subfunction */
#define RESET_MCC               0xFF /* MCC reset. */

/*===================================*/
/*                                   */
/* MQX-32 Features                   */
/*                                   */
/*===================================*/

#define F_BASIC                 0x01 /* Basic interface function */
#define F_CLS                   0x02 /* Chase lock sync */
#define F_SMPTE                 0x04 /* SMTPE capable */
#define F_MULTIPORT             0x08 /* Multiple MIDI out ports */
#define F_CHAN_SPLIT            0x20 /* Channel splitting */
#define F_HIRES_TIMER           0x40 /* Hi-resolution (216,240 tpb) timer */

/*===================================*/
/*                                   */
/* PC MIDI Card Features             */
/*                                   */
/*===================================*/

#define F_PROG_METRO            0x10 /* Programmable metronome */

/*===================================*/
/*                                   */
/* Function prototypes               */
/*                                   */
/*===================================*/

#ifdef __cplusplus
extern "C" {
#endif

int mcc_command(unsigned char cmd);
int mcc_reset(void);
int mcc_get(void);
int mcc_put(unsigned char mbyte);
void mcc_flush(void);
void mcc_close(void);
void mcc_close_nr(void);
void mcc_noslih(void);
void mcc_receive(void);
void set_slih(void (*fct)(void));
int mcc_open(unsigned address, unsigned irq);
unsigned mcc_irq(unsigned address);

void coproc_slih(void);
int rec_overflow(void);
int track_efw(unsigned track);
int conductor_efw(void);
int clock_efw(void);
int ackn_efw(void);
int playend_efw(void);
int recordend_efw(void);
int measureend_efw(void);
int spp_efw(int *spp);
int smpte_efw(unsigned char *frame);
int cuepoint_efw(void);
int realtime_efw(void);
int strk_end_efw(void);
int rec_bytes(void);
void rec_init(unsigned buffseg, unsigned buffoff, unsigned buffsize);
void set_tdr(void (*fct)(void));
void set_cdr(void (*fct)(void));

void mclk_init(int ticcount);
void mclk_start(void);
void mclk_stop(void);
unsigned midi_clock(void);
int set_trq(int *efw, int timevalue);
void set_trq_time(int handle, int timevalue);
void add_trq_time(int handle, int timevalue);
void end_trq(int handle);
void clear_efw(int *efw);

#ifdef __cplusplus
}
#endif
