DECLARE FUNCTION mddl% (cmd%)
DECLARE SUB setupmcc ()
'*===================================*
'*                                   *
'* Music Quest Programmer's ToolKit  *
'* Sequencer - Record/playback       *
'*                                   *
'*===================================*
'*                                   *
'* Copyright (c) 1988                *
'* Music Quest, Inc.                 *
'*                                   *
'*===================================*

DEFINT A-Z

' $INCLUDE: 'mcc.cst'
' $INCLUDE: 'mcc.inc'

DECLARE SUB tdr ()

DIM SHARED ptrack AS STRING * 8192      ' record/play track
COMMON SHARED recflag%                  ' 1=recorded
COMMON SHARED tracksize%                ' how much recorded
COMMON SHARED trkp%                     ' play back track pointer to next byte
COMMON SHARED cmdl%                     ' data length for MIDI running status

'*===================================*
'*                                   *
'* Initialize record/play            *
'*                                   *
'*===================================*

'*===================================*
'*                                   *
'* Determine MIDI data length        *
'*                                   *
'*===================================*

'*===================================*
'*                                   *
'* Set up MCC for record/play        *
'*                                   *
'*===================================*

'*===================================*
'*                                   *
'* Record a track                    *
'*                                   *
'*===================================*

'*===================================*
'*                                   *
'* Playback recorded track           *
'*                                   *
'*===================================*

'*===================================*
'*                                   *
'* Respond to TDR by sending next    *
'* track event                       *
'*                                   *
'* Note that variable tdrp and cmdl  *
'* were set up by the play back      *
'* routine.                          *
'*                                   *
'*===================================*

SUB initrecplay
  reflag% = 0
  tracksize% = 0
END SUB

FUNCTION mddl (cmd%)
  cmdx% = (cmd AND &H70) \ 16
  mddl = 2
  IF cmdx > 3 THEN
    IF cmdx < 6 THEN
      mddl = 1
    ELSE
      IF cmdx = 7 THEN
        mddl = 0
      END IF
    END IF
  END IF
END FUNCTION

SUB playtrack

DIM mcmddl%(0 TO 7)                     '* midi command data lengths *
mididl: DATA 2,2,2,2,1,1,2,0

  IF recflag THEN
      CLS
      PRINT "Track Play Back"; CHR$(10)
      PRINT "Press any key to stop play...."

      LOCATE 6, 1                       'set up running beat counter
      beatefw = 0                       ' clear event flag word
      beats = 1
      PRINT "Beat "; beats
      trqx = settrq(VARPTR(beatefw), 96)'96 ticks = 1 beat = 1/4 note

      trkp% = VARPTR(ptrack) + 4        '* address of first track byte
      cmdl% = 2                         '* length for default running status

      setupmcc                          '* set up co-processor interrupt handler
      mclkstart                         '* start clokc-to-PC messages
      rc = mcccommand(ACTIVE.TRACKS)    '* activate track 1 *
      mccput (&H1)
      rc = mcccommand(CLEAR.PLAY.TRACKS)'* clear play counters *
      rc = mcccommand(START.PLAY)       '* start play *

      '* This is the body of play back

      eotflag% = 0                      '* end of track flag
      WHILE (INKEY$ = "") AND (eotflag = 0)'* loop until key or end of track
        tdr                             '* respond to TDRs
        IF beatefw <> 0 THEN            ' beat counter update
            clearefw (VARPTR(beatefw))  ' reset EFW
            settrqtime trqx, 96         ' reset beat TRQ
            beats = beats + 1
            LOCATE 6, 6
            PRINT beats                 ' show new beat counter
        END IF
        eotflag = playendefw            '* test for track end
      WEND

      IF eotflag THEN                   '* end of track
        PRINT CHR$(10); CHR$(10); "End of recorded MIDI data"
        PRINT "Press any key to continue"
        WHILE INKEY$ = ""               ' wait for key
        WEND
      END IF

      '* Stopping play back is an involved process, as the following shows

      rc = clockefw                     '* must wait to next MIDI clock
      WHILE clockefw = 0
          tdr                           '* if a TDR occurs, answer it
      WEND
      WHILE mcccommand(STOP.PLAY) = 0   '* stop play (issued just after clock)
          tdr                           '* a TDR is the likely cause for failure
      WEND
      WHILE clockefw = 0                '* stop actually occurs at next clock
          tdr                           '* if a TDR occurs, answer it
      WEND

      mclkstop                          '* turn off clock interrupts
      endtrq (trqx)                     ' release our beat counter TRQ

  ELSE
      CLS
      PRINT "No data recorded"
      PRINT "Press any key to continue"
      WHILE INKEY$ = ""
      WEND
  END IF
END SUB

SUB recordtrack
  recinit VARSEG(ptrack), VARPTR(ptrack) + 4, 8192' set up track recorder
  setupmcc

  CLS
  PRINT "Record MIDI Data"; CHR$(10); CHR$(10)
  PRINT "Press any key to stop recording...."

  LOCATE 6, 1                           'set up running beat counter
  beatefw = 0                           ' clear event flag word
  beats = 1
  PRINT "Beat "; beats
  trqx = settrq(VARPTR(beatefw), 96)    '96 ticks = 1 beat = 1/4 note

  mclkstart                             'start clock to PC
  rc = mcccommand(METRO.ON)             '* metronome on for recording *
  rc = mcccommand(START.REC)            ' start recording

  WHILE INKEY$ = ""                     ' wait for key
    IF beatefw <> 0 THEN                ' beat counter update
        clearefw (VARPTR(beatefw))      ' reset EFW
        settrqtime trqx, 96             ' reset beat TRQ
        beats = beats + 1
        LOCATE 6, 6
        PRINT beats                     ' show new beat counter
    END IF
  WEND

  rc = mcccommand(STOP.REC)             ' stop recording

  DO WHILE recordendefw = 0             ' wait for end of track received
  LOOP
  tracksize% = recbytes
  PRINT CHR$(10); tracksize; " bytes recorded"

  rc = mcccommand(METRO.OFF)            ' metronome off
  mclkstop                              ' stop clock to PC
  endtrq (trqx)                         ' release our beat counter TRQ
  recflag% = 1

  PRINT "Press any key to continue"
  WHILE INKEY$ = ""                     ' wait for key
  WEND

END SUB

SUB setupmcc
  mccreset
  rc = mcccommand(DISABLE.MEASUREND)    '* measure end off
  rc = mcccommand(INT.CLOCK.96)         '* 96 PPB
  rc = mcccommand(DISABLE.CONDUCTOR)    '* conductor off
  rc = mcccommand(SET.TEMPO)            '* set tempo
  mccput (66)                           '* 66 beats/min
  rc = mcccommand(DISABLE.ALL.THRU)     '* disable THRU mode
  rc = mcccommand(DISABLE.THRU)
  rc = mcccommand(ENABLE.BENDER.PC)     '* pitch bend to host
  rc = mcccommand(CHANNELS.1)           '* enable all channels
  mccput (&HFF)
  rc = mcccommand(CHANNELS.9)
  mccput (&HFF)
  rc = mcccommand(SET.METRO)            '* set tics/beat
  mccput (24)                           '* 1/4 note = beat
  rc = mcccommand(SET.BPM)              '* set beats/measure
  mccput (4)                            '* 4 beats/measure
  rc = mcccommand(METRO.OFF)            '* metronome off
  rc = mcccommand(SET.CLOCK.PC)         '* set clock to PC frequency
  mccput (16)                           '* every 4 clock ticks
  mclkinit (4)                          '* set up clock services
                                        '* 1 clock to PC interrupt = 4 ticks
  mccsetcoprocslih                      '* set up co-processor interrupt handler
END SUB

SUB tdr
        IF trackefw(0) <> 0 THEN        '* TDR received on track 1
            tbyte% = PEEK(trkp)         '* get next track byte (timing byte)
            trkp% = trkp + 1
            IF tbyte = &HF8 THEN        '* timer overflow event
                mccput (&HF8)
            ELSE
              mccput (tbyte)            '* send new timing byte
              tbyte% = PEEK(trkp)       '* get next track byte (status or data)
              trkp% = trkp + 1
              IF tbyte AND &H80 THEN    '* new running status
                  mccput (tbyte)        '* send new status byte
                  cmdl% = mddl(tbyte)   '* new length
                  FOR i = 1 TO cmdl     '* send data
                      tbyte% = PEEK(trkp)'* get next track byte
                      trkp% = trkp + 1
                      mccput (tbyte)
                  NEXT i
              ELSE                      '* continuing status
                  mccput (tbyte)        '* send first byte of message
                  IF cmdl = 2 THEN      '* send second byte
                      tbyte% = PEEK(trkp)'* get next track byte
                      trkp% = trkp + 1
                      mccput (tbyte)
                  END IF
              END IF
            END IF
        END IF
END SUB

