/*===================================*/
/*                                   */
/* Music Quest Programmer's ToolKit  */
/*                                   */
/* Interpreted Trace                 */
/*                                   */
/* Copyright (c) 1988                */
/* By Music Quest, Inc.              */
/*                                   */
/*===================================*/
#include "dos.h"
#include "bios.h"
#include "\ptk\asm\mcc.h"

/*===================================*/
/*                                   */
/* Formatted trace                   */
/*                                   */
/*===================================*/
tk_itrace()
{
  int midi_c;
  int k;
  char byte1, byte2;
  int channel;
  int cmdx;
  int sysex_sw;
  char line[81];
  int rstatus;

  puts("Press any key to end trace.");
  set_slih(mcc_receive);                /* set up our slih */
  mcc_command(UART_MODE);               /* put MMC in pass thru */

  channel=midi_c=sysex_sw=0;
  rstatus=1;                            /* running status = note on */
  while (!_bios_keybrd(_KEYBRD_READY))  /* until escape */
    if (sysex_sw || ((midi_c=mcc_get()) >=0))
      {
        sysex_sw=0;
        if (midi_c & 0x80)              /* new status? */
          if (midi_c < 0xF0)            /* non-system message? */
            {
              channel=(midi_c & 0x0F)+1;
              rstatus=cmdx=(midi_c & 0x70) >> 4;
              byte1=midigetw();
            }
          else                          /* system message */
            cmdx=7;
        else                            /* running status */
          {
            byte1=midi_c;
            cmdx=rstatus;
          }
        switch (cmdx)
          {
            case 0:
              byte2=midigetw();
              printf("Note off            channel=%-2d key=%-3d velocity=%-3d\n",channel,byte1,byte2);
              break;
            case 1:
              byte2=midigetw();
              printf("Note on             channel=%-2d key=%-3d velocity=%-3d\n",channel,byte1,byte2);
              break;
            case 2:
              byte2=midigetw();
              printf("Key aftertouch      channel=%-2d key=%-3d pressure=%-3d\n",channel,byte1,byte2);
              break;
            case 3:
              byte2=midigetw();
              printf("Control change      channel=%-2d controller=%-3d value=%-3d\n",channel,byte1,byte2);
              break;
            case 4:
              printf("Program change      channel=%-2d program=%-3d\n",channel,byte1);
              break;
            case 5:
              printf("Channel aftertouch  channel=%-2d pressure=%-3d\n",channel,byte1);
              break;
            case 6:
              byte2=midigetw();
              printf("Pitch bend          channel=%-2d bend=0x%04X\n",channel,(byte2 << 7)+byte1);
              break;
            case 7:
              switch (midi_c & 0x0F)
                {
                  case 0:               /* sys ex */
                    printf("System exclusive    ");
                    k=16;
                    do
                      {
                        midi_c=midigetw();
                        printf("%02X ",midi_c);
                        if (!(--k))
                          {
                            printf("\n                    ");
                            k=16;
                          }
                      }
                    while (!(midi_c & 0x80));
                    puts("");
                    if (midi_c != 0xF7)       /* ended on new command, not eox */
                      sysex_sw=1;
                    break;
                  case 1:               /* midi time code */
                    byte1=midigetw();
                    printf("MIDI time code      code=%02X\n",byte1);
                    break;
                  case 2:               /* song position */
                    byte1=midigetw();
                    byte2=midigetw();
                    printf("Song position       beats=%-2d\n",(byte2 << 7)+byte1);
                    break;
                  case 3:               /* song select */
                    byte1=midigetw();
                    printf("Song select         song=%-2d\n",byte1);
                    break;
                  case 6:               /* tune request */
                    puts("Tune request");
                    break;
                  case 8:               /* clock */
                    puts("Clock");
                    break;
                  case 9:
                    break;
                  case 10:              /* start */
                    puts("Start");
                    break;
                  case 11:              /* continue */
                    puts("Continue");
                    break;
                  case 12:
                    puts("Stop");
                    break;
                  case 13:
                    break;
                  case 14:              /* active sensing */
                    break;
                  case 15:
                    puts("System reset");
                    break;
                  default:
                    printf("Undefined           status=%02X\n",midi_c);
                    break;
                }
              break;
          }
      }

  set_slih(mcc_noslih);                 /* default slih */
  mcc_reset();                          /* return to coproc mode */
  _bios_keybrd(_KEYBRD_READ);           /* clear exit key */
}

/*===================================*/
/*                                   */
/* Wait for the next MIDI data byte  */
/*                                   */
/*===================================*/
midigetw()
{
  long t, clock;
  int mbyte;

  _bios_timeofday(_TIME_GETCLOCK,&t);   /* max wait of 1 sec */
  t+=18L;

  do
    {
    if ((mbyte=mcc_get()) >= 0)
      break;
    else
      _bios_timeofday(_TIME_GETCLOCK,&clock);
    }
  while (t > clock);                    /* spin until data or time out */

  return(mbyte);
}
