{*===================================*}
{*                                   *}
{* Music Quest Programmer's ToolKit  *}
{* Function/procedure prototypes     *}
{*                                   *}
{*===================================*}
{*                                   *}
{* Copyright 1987, 1990              *}
{* Music Quest, Inc.                 *}
{*                                   *}
{*===================================*}

unit mcc;

interface

type
  smpte_fid = array[0..3] of byte;

function _mcc_open(address,intlevel: integer): integer;
function _mcc_irq(address: integer): integer;
function _mcc_get: integer;
procedure _mcc_put(byte: integer);
procedure _mcc_flush;
procedure _mcc_close;
procedure _mcc_set_noslih;
procedure _mcc_set_receiveslih;
procedure _mcc_set_coprocslih;
function _mcc_command(command: integer): integer;
procedure mcccommand;  {not callable from Pascal}
procedure _mcc_reset;
procedure _coproc_slih;
function _rec_overflow: integer;
function _track_efw(track: integer): integer;
function _conductor_efw: integer;
function _ackn_efw: integer;
function _playend_efw: integer;
function _recordend_efw: integer;
function _measurend_efw: integer;
function _clock_efw: integer;
procedure _spp_efw(var efw, spp: integer);
procedure _smpte_efw(var efw: integer; var fid: smpte_fid);
function _cuepoint_efw: integer;
function _realtime_efw: integer;
function _strk_end_efw: integer;
function _rec_bytes: integer;
procedure _rec_init(buffseg,buffoff,size: integer);
procedure _mclk_init(ticvalue: integer);
procedure _mclk_start;
procedure _mclk_stop;
function _midi_clock: integer;
procedure clock_tic;
function _set_trq(var efw: integer; time: integer): integer;
procedure _set_trq_time(trqx: integer; time: integer);
procedure _add_trq_time(trqx: integer; time: integer);
procedure _end_trq(trqhx: integer);
procedure _clear_efw(var efw: integer);

implementation

{$L MCCTKFP}
function _mcc_open; external;
function _mcc_irq; external;
function _mcc_get; external;
procedure _mcc_put; external;
procedure _mcc_flush; external;
procedure _mcc_close; external;
procedure _mcc_set_noslih; external;
procedure _mcc_set_receiveslih; external;
procedure _mcc_set_coprocslih; external;
function _mcc_command; external;
procedure mcccommand; external; {not callable from Pascal}
procedure _mcc_reset; external;

{$L MCCTKIHP}
procedure _coproc_slih; external;
function _rec_overflow; external;
function _track_efw; external;
function _conductor_efw; external;
function _ackn_efw; external;
function _playend_efw; external;
function _recordend_efw; external;
function _measurend_efw; external;
function _clock_efw; external;
procedure _spp_efw; external;
procedure _smpte_efw; external;
function _cuepoint_efw; external;
function _realtime_efw; external;
function _strk_end_efw; external;
function _rec_bytes; external;
procedure _rec_init; external;

{$L MCCTKCKP}
procedure _mclk_init; external;
procedure _mclk_start; external;
procedure _mclk_stop; external;
function _midi_clock; external;
procedure clock_tic; external;
function _set_trq; external;
procedure _set_trq_time; external;
procedure _add_trq_time; external;
procedure _end_trq; external;
procedure _clear_efw; external;
end.
